
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Transactions;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
using gov.va.med.vbecs.Common;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
    [TestFixture]
    public class DAL_PendingSpecimenTest : BaseTest
    {
        [Test]
        [Category("UC_115_AutomatedTesting")]
        public void GetPendingSpecimenTest_Pass()
        {
            using (TransactionScope scope = new TransactionScope())
            {
                // Arrange
                InsertData(PendingTestStatus.Pending);

                //Act
                var dtPendingBloodUnitTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PendingSpecimenTest WHERE PendingTestStatusId = " + ((int)PendingTestStatus.Pending).ToString() + " AND DivisionCode = '" + this.TestDivisionCode + "'", false);

                // Assert
                Assert.IsTrue(dtPendingBloodUnitTest.Rows.Count > 0);
            }
        }

        private void InsertData(PendingTestStatus pendingTestStatus)
        {
            Guid otGuid = Guid.NewGuid();
            Guid psGuid = Guid.NewGuid();
            Guid poGuid = Guid.NewGuid();
            Guid ptGuid = Guid.NewGuid();
            Guid pGuid = (Guid)DataCreator.GetRandomPatientRecord(true).Rows[0][TABLES.Patient.PatientGuid];

            DataCreator.InsertPatientTreatment(ptGuid, pGuid);
            DataCreator.InsertPatientOrder(poGuid, ptGuid);
            DataCreator.InsertPatientSpecimen(psGuid, pGuid, false);
            DataCreator.InsertOrderedTest(otGuid, poGuid, psGuid, OrderableTest.TAS);

            var divisionCode = this.TestDivisionCode;
            var statusId = ((int)pendingTestStatus).ToString();

            string sql =
            "INSERT [dbo].[PendingSpecimenTest] ([SpecimenTestGuid], [OrderedTestGuid], [PatientSpecimenGuid], [BloodTestTypeId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentName], [AutoInstrumentComments], [DivisionCode], [PendingTestStatusId], [RejectionComment], [SpecimenResultSetGuid], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (NULL, N'" + otGuid.ToString() + "', N'" + psGuid.ToString() + "', 62, CAST(N'2016-01-27 12:30:42.000' AS DateTime), N'DNS   DOBRAK', N'0  ', N'ProVue', N'', N'" + divisionCode + "', " + statusId + ", NULL, N'1a0bb1a1-9225-451b-9781-3cdbfd306a72', CAST(N'2016-01-29 19:30:14.007' AS DateTime), N'DNS   forstd', 82)" +
            "INSERT [dbo].[PendingSpecimenTest] ([SpecimenTestGuid], [OrderedTestGuid], [PatientSpecimenGuid], [BloodTestTypeId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentName], [AutoInstrumentComments], [DivisionCode], [PendingTestStatusId], [RejectionComment], [SpecimenResultSetGuid], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (NULL, N'" + otGuid.ToString() + "', N'" + psGuid.ToString() + "', 63, CAST(N'2016-01-27 12:30:42.000' AS DateTime), N'DNS   DOBRAK', N'4  ', N'ProVue', N'', N'" + divisionCode + "', " + statusId + ", NULL, N'1a0bb1a1-9225-451b-9781-3cdbfd306a72', CAST(N'2016-01-29 19:30:14.007' AS DateTime), N'DNS   forstd', 82)" +
            "INSERT [dbo].[PendingSpecimenTest] ([SpecimenTestGuid], [OrderedTestGuid], [PatientSpecimenGuid], [BloodTestTypeId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentName], [AutoInstrumentComments], [DivisionCode], [PendingTestStatusId], [RejectionComment], [SpecimenResultSetGuid], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (NULL, N'" + otGuid.ToString() + "', N'" + psGuid.ToString() + "', 69, CAST(N'2016-01-27 12:30:42.000' AS DateTime), N'DNS   DOBRAK', N'1  ', N'ProVue', N'', N'" + divisionCode + "', " + statusId + ", NULL, N'1a0bb1a1-9225-451b-9781-3cdbfd306a72', CAST(N'2016-01-29 19:30:14.007' AS DateTime), N'DNS   forstd', 82)" +
            "INSERT [dbo].[PendingSpecimenTest] ([SpecimenTestGuid], [OrderedTestGuid], [PatientSpecimenGuid], [BloodTestTypeId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentName], [AutoInstrumentComments], [DivisionCode], [PendingTestStatusId], [RejectionComment], [SpecimenResultSetGuid], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (NULL, N'" + otGuid.ToString() + "', N'" + psGuid.ToString() + "', 71, CAST(N'2016-01-27 12:30:42.000' AS DateTime), N'DNS   DOBRAK', N'0  ', N'ProVue', N'', N'" + divisionCode + "', " + statusId + ", NULL, N'1a0bb1a1-9225-451b-9781-3cdbfd306a72', CAST(N'2016-01-29 19:30:14.007' AS DateTime), N'DNS   forstd', 82)" +
            "INSERT [dbo].[PendingSpecimenTest] ([SpecimenTestGuid], [OrderedTestGuid], [PatientSpecimenGuid], [BloodTestTypeId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentName], [AutoInstrumentComments], [DivisionCode], [PendingTestStatusId], [RejectionComment], [SpecimenResultSetGuid], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (NULL, N'" + otGuid.ToString() + "', N'" + psGuid.ToString() + "', 66, CAST(N'2016-01-27 12:30:42.000' AS DateTime), N'DNS   DOBRAK', N'4  ', N'ProVue', N'', N'" + divisionCode + "', " + statusId + ", NULL, N'1a0bb1a1-9225-451b-9781-3cdbfd306a72', CAST(N'2016-01-29 19:30:14.007' AS DateTime), N'DNS   forstd', 82)" +
            "INSERT [dbo].[PendingSpecimenTest] ([SpecimenTestGuid], [OrderedTestGuid], [PatientSpecimenGuid], [BloodTestTypeId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentName], [AutoInstrumentComments], [DivisionCode], [PendingTestStatusId], [RejectionComment], [SpecimenResultSetGuid], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (NULL, N'" + otGuid.ToString() + "', N'" + psGuid.ToString() + "', 67, CAST(N'2016-01-27 12:30:42.000' AS DateTime), N'DNS   DOBRAK', N'0  ', N'ProVue', N'', N'" + divisionCode + "', " + statusId + ", NULL, N'1a0bb1a1-9225-451b-9781-3cdbfd306a72', CAST(N'2016-01-29 19:30:14.007' AS DateTime), N'DNS   forstd', 82)" +
            "INSERT [dbo].[PendingSpecimenTest] ([SpecimenTestGuid], [OrderedTestGuid], [PatientSpecimenGuid], [BloodTestTypeId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentName], [AutoInstrumentComments], [DivisionCode], [PendingTestStatusId], [RejectionComment], [SpecimenResultSetGuid], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId]) VALUES (NULL, N'" + otGuid.ToString() + "', N'" + psGuid.ToString() + "', 65, CAST(N'2016-01-27 12:30:42.000' AS DateTime), N'DNS   DOBRAK', N'B  ', N'ProVue', N'Testing TAS from ProVue', N'" + divisionCode + "', " + statusId + ", NULL, N'1a0bb1a1-9225-451b-9781-3cdbfd306a72', CAST(N'2016-01-29 19:30:14.007' AS DateTime), N'DNS   forstd', 82)";
            UnitTestUtil.RunSQL(sql);
        }

        private void DeleteTableData()
        {
            UnitTestUtil.RunSQL("DELETE PendingSpecimenTest");
        }
    }
}


#endif



